@REM  This batch file was created to run the DailyDayCent Oak Ridge
@REM  simulations on the PC.  There are four simulations: east and west, based
@REM  on the C14data @REM  files, and low and high, based on the C/N ratio of
@REM  the organic matter added

@REM  Copy the desired site file/weather file combination to oakridge.100/
@REM  oakridge.wth
copy oakridge_daymet_walker_branch_TDE.100 oakridge.100
copy oakridge_daymet_walker_branch_TDE.wth oakridge.wth

@REM  Remove old output files
erase orlow_east.bin
erase orlow_east.lis
erase orlow_east_mresp.out
erase orlow_east_gresp.out
erase orlow_east_dels.out
erase orlow_west.bin
erase orlow_west.lis
erase orlow_west_mresp.out
erase orlow_west_gresp.out
erase orlow_east_dels.out
erase orhigh_east.bin
erase orhigh_east.lis
erase orhigh_east_mresp.out
erase orhigh_east_gresp.out
erase orlow_east_dels.out
erase orhigh_west.bin
erase orhigh_west.lis
erase orhigh_west_mresp.out
erase orhigh_west_gresp.out
erase orlow_east_dels.out

@REM  Run the C14 east data file simulations
copy c14_east.dat c14data

@REM  Run the low organic matter addition schedule file
DailyDayCent -s orlow_east.sch -n orlow_east > out_low_east.txt
DailyDayCent_list100 orlow_east orlow_east outvars.txt
copy mresp.out orlow_east_mresp.out
copy gresp.out orlow_east_gresp.out
copy dels.out orlow_east_dels.out

@REM  Run the high organic matter addition schedule file
DailyDayCent -s orhigh_east.sch -n orhigh_east > out_high_east.txt
DailyDayCent_list100 orhigh_east orhigh_east outvars.txt
copy mresp.out orhigh_east_mresp.out
copy gresp.out orhigh_east_gresp.out
copy dels.out orhigh_east_dels.out

@REM  Run the C14 west data file simulations
copy c14_west.dat c14data

@REM  Run the low organic matter addition schedule file
DailyDayCent -s orlow_west.sch -n orlow_west > out_low_west.txt
DailyDayCent_list100 orlow_west orlow_west outvars.txt
copy mresp.out orlow_west_mresp.out
copy gresp.out orlow_west_gresp.out
copy dels.out orlow_west_dels.out

@REM  Run the high organic matter addition schedule file
DailyDayCent -s orhigh_west.sch -n orhigh_west > out_high_west.txt
DailyDayCent_list100 orhigh_west orhigh_west outvars.txt
copy mresp.out orhigh_west_mresp.out
copy gresp.out orhigh_west_gresp.out
copy dels.out orhigh_west_dels.out

@REM  Remove the files that we have finished using
@REM  erase oakridge.100
@REM  erase oakridge.wth
erase c14data
