@REM This batch file runs Daycent_photosyn priming simulations


@REM Remove old output files with .bat extension

erase *.bin


@REM Run spin-up simulations using unchanged decay rate

copy fix_0.100 fix.100

DayCent_Photosyn -s spin -n spin > spin_log.txt
DayCent_Photosyn_list100 spin spin outvars.txt
copy dc_sip.csv spin_dc_sip.csv

DayCent_Photosyn -s base -n base -e spin > base_log.txt
DayCent_Photosyn_list100 base base outvars.txt
copy dc_sip.csv base_dc_sip.csv

DayCent_Photosyn -s co2spin -n co2spin -e base > co2spin_log.txt
DayCent_Photosyn_list100 co2spin co2spin outvars.txt
copy dc_sip.csv co2spin_dc_sip.csv


@REM Run ambient simulation using unchanged decay rate

DayCent_Photosyn -s amb -n amb -e co2spin > amb_log.txt
DayCent_Photosyn_list100 amb amb outvars.txt
copy dc_sip.csv amb_dc_sip.csv


@REM Run CO2 simulation using unchanged decay rate

DayCent_Photosyn -s co2 -n co2_0 -e co2spin > co2_0_log.txt
DayCent_Photosyn_list100 co2_0 co2_0 outvars.txt
copy dc_sip.csv co2_0_dc_sip.csv

copy fix.100 fix_0.100
erase fix.100


@REM Run CO2 simulation with microbial pool decay rate increased by +10%

copy fix_dec3_10.100 fix.100

DayCent_Photosyn -s co2 -n co2_dec3_10 -e co2spin > co2_dec3_10_log.txt
DayCent_Photosyn_list100 co2_dec3_10 co2_dec3_10 outvars.txt
copy dc_sip.csv co2_dec3_10_dc_sip.csv

copy fix.100 fix_dec3_10.100
erase fix.100


@REM Run CO2 simulation with microbial pool decay rate increased by +30%

copy fix_dec3_30.100 fix.100

DayCent_Photosyn -s co2 -n co2_dec3_30 -e co2spin > co2_dec3_30_log.txt
DayCent_Photosyn_list100 co2_dec3_30 co2_dec3_30 outvars.txt
copy dc_sip.csv co2_dec3_30_dc_sip.csv

copy fix.100 fix_dec3_30.100
erase fix.100


@REM Run CO2 simulation with microbial pool decay rate increased by +50%

copy fix_dec3_50.100 fix.100

DayCent_Photosyn -s co2 -n co2_dec3_50 -e co2spin > co2_dec3_50_log.txt
DayCent_Photosyn_list100 co2_dec3_50 co2_dec3_50 outvars.txt
copy dc_sip.csv co2_dec3_50_dc_sip.csv

copy fix.100 fix_dec3_50.100
erase fix.100


@REM Run CO2 simulation with slow pool decay rate increased by +10%

copy fix_dec5_10.100 fix.100

DayCent_Photosyn -s co2 -n co2_dec5_10 -e co2spin > co2_dec5_10_log.txt
DayCent_Photosyn_list100 co2_dec5_10 co2_dec5_10 outvars.txt
copy dc_sip.csv co2_dec5_10_dc_sip.csv

copy fix.100 fix_dec5_10.100
erase fix.100


@REM Run CO2 simulation with slow pool decay rate increased by +30%

copy fix_dec5_30.100 fix.100

DayCent_Photosyn -s co2 -n co2_dec5_30 -e co2spin > co2_dec5_30_log.txt
DayCent_Photosyn_list100 co2_dec5_30 co2_dec5_30 outvars.txt
copy dc_sip.csv co2_dec5_30_dc_sip.csv

copy fix.100 fix_dec5_30.100
erase fix.100


@REM Run CO2 simulation with slow pool decay rate increased by +50%

copy fix_dec5_50.100 fix.100

DayCent_Photosyn -s co2 -n co2_dec5_50 -e co2spin > co2_dec5_50_log.txt
DayCent_Photosyn_list100 co2_dec5_50 co2_dec5_50 outvars.txt
copy dc_sip.csv co2_dec5_50_dc_sip.csv

copy fix.100 fix_dec5_50.100
erase fix.100


@REM Run CO2 simulation with passive pool decay rate increased by +10%

copy fix_dec4_10.100 fix.100

DayCent_Photosyn -s co2 -n co2_dec4_10 -e co2spin > co2_dec4_10_log.txt
DayCent_Photosyn_list100 co2_dec4_10 co2_dec4_10 outvars.txt
copy dc_sip.csv co2_dec4_10_dc_sip.csv

copy fix.100 fix_dec4_10.100
erase fix.100


@REM Run CO2 simulation with passive pool decay rate increased by +10%

copy fix_dec4_30.100 fix.100

DayCent_Photosyn -s co2 -n co2_dec4_30 -e co2spin > co2_dec4_30_log.txt
DayCent_Photosyn_list100 co2_dec4_30 co2_dec4_30 outvars.txt
copy dc_sip.csv co2_dec4_30_dc_sip.csv

copy fix.100 fix_dec4_30.100
erase fix.100


@REM Run CO2 simulation with passive pool decay rate increased by +10%

copy fix_dec4_50.100 fix.100

DayCent_Photosyn -s co2 -n co2_dec4_50 -e co2spin > co2_dec4_50_log.txt
DayCent_Photosyn_list100 co2_dec4_50 co2_dec4_50 outvars.txt
copy dc_sip.csv co2_dec4_50_dc_sip.csv
erase dc_sip.csv

copy fix.100 fix_dec4_50.100
erase fix.100
