# Priming synthesis paper Weixin 2013
# process output files from daycent_photosyn priming simulations


rm(list=ls())

setwd("/Users/dacheat/desktop/Weixin root priming paper/priming_synthesis_daycent_photosyn_duke_face/output")

##### read files

### for dc_sip
# create a list of file names in the directory
dc_sip.names <- list.files(path="/Users/dacheat/desktop/Weixin root priming paper/priming_synthesis_daycent_photosyn_duke_face/output", pattern="._dc_sip.csv")

# read files into an array 
dc_sip <- lapply(dc_sip.names, function(x){read.csv(file=x,header=T)})

# restrict array to 1995-2013 (some files include years before 1995)
for (i in 1:length(dc_sip)){
	dc_sip[[i]] <- dc_sip[[i]][dc_sip[[i]]$time>=1996 & dc_sip[[i]]$time<2014,]
}


### for .lis 
# create a list of file names of appropriate ones in the directory
lis.names <- list.files(path="/Users/dacheat/desktop/Weixin root priming paper/priming_synthesis_daycent_photosyn_duke_face/output", pattern=".lis")

# read files into an array 
lis <- lapply(lis.names, function(x){read.table(file=x,header=T)})

# restrict array to 1995-2013 (some files include years before 1995)
for (i in 1:length(lis)){
	lis[[i]] <- lis[[i]][lis[[i]]$time>=1996 & lis[[i]]$time<2014,]
}

# create a daily version of .lis, by merging with dc_sip
for (i in 1:length(lis)){
	lis[[i]] <- merge(x=dc_sip[[i]], y=lis[[i]], by.x="time", by.y="time")
}



##### sort data into array

### make a data frame with the right col names
data <- matrix(NA, nrow=nrow(dc_sip[[1]]), ncol=8, dimnames=list(NULL,c("year","doy","npp","nup","soc","soc1","soc2","soc3")))
data <- data.frame(data)

### create array 
data <- replicate(length(dc_sip), list(data))
names(data) <- dc_sip.names


### get data in
for (i in 1:length(data)){
	
# col=1, variable=year, units=null, name=YEAR, type=time
data[[i]]$year <- trunc(dc_sip[[i]]$time)

# 2, day of the year, null, DOY, time
data[[i]]$doy <- dc_sip[[i]]$dayofyr

# 3, net primary productivity, gC m-2 d-1, NPP, flux
data[[i]]$npp <- dc_sip[[i]]$NPP

# 4, N biomass uptake gN m-2 d-1, NUP, flux
data[[i]]$nup <- lis[[i]]$eprodf.1./30

# 5, total C in SOM pool (0-30cm), gC m-2 SOC, pool
data[[i]]$soc <- dc_sip[[i]]$som1c.2. + dc_sip[[i]]$som2c.2. + dc_sip[[i]]$som3c

# 6, C in microbial SOM pool (0-30cm), gC m-2, SOC1, pool
data[[i]]$soc1 <- dc_sip[[i]]$som1c.2.

# 7, C in slow SOM pool (0-30cm), gC m-2, SOC2, pool
data[[i]]$soc2 <- dc_sip[[i]]$som2c.2.

# 8, C in passive SOM pool (0-30cm), gC m-2, SOC2, pool
data[[i]]$soc3 <- dc_sip[[i]]$som3c

}



##### make table

# sum fluxes annually, average daily pools by year
annual1<-data
annual2<-data
annual<-data

for (i in 1:length(data)){
	annual1[[i]]<-aggregate(data[[i]][,c("npp","nup")], list(year=data[[i]]$year), FUN=sum)
	annual2[[i]]<-aggregate(data[[i]][,c("soc","soc1","soc2","soc3")], list(year=data[[i]]$year), FUN=mean)
	annual[[i]]<-cbind(annual1[[i]][annual1[[i]]$year>=1996 & annual1[[i]]$year<2004,], annual2[[i]][annual2[[i]]$year>=1996 & annual2[[i]]$year<2004,c("soc","soc1","soc2","soc3")])
}



# calculate averages from 1996 to 2004
table<-matrix(NA, nrow=length(annual), ncol=9)
table<-as.data.frame(table)
colnames(table)=c("type","prime","plus","npp","nup","soctot","soc1","soc2","soc3")
table$type<-names(annual)
table$prime<-c("without","microbial","microbial","microbial","passive","passive","passive","slow","slow","slow")
table$plus<-c("0%","10%","30%","50%","10%","30%","50%","10%","30%","50%")
for (i in 1:length(annual)) {
	table$npp[i]<-mean(annual[[i]]$npp[annual[[i]]$year>=1996 & annual[[i]]$year<2004])
	table$nup[i]<-mean(annual[[i]]$nup[annual[[i]]$year>=1996 & annual[[i]]$year<2004])
	table$soctot[i]<-mean(annual[[i]]$soc[annual[[i]]$year>=1996 & annual[[i]]$year<2004])  
	table$soc1[i]<-mean(annual[[i]]$soc1[annual[[i]]$year>=1996 & annual[[i]]$year<2004])	
	table$soc2[i]<-mean(annual[[i]]$soc2[annual[[i]]$year>=1996 & annual[[i]]$year<2004])
	table$soc3[i]<-mean(annual[[i]]$soc3[annual[[i]]$year>=1996 & annual[[i]]$year<2004])
}
table[,4:ncol(table)]<-signif(table[,4:ncol(table)], digits=3)

table

